/** @file   menulevelchange.cpp
 * @brief   Implementation of MenuLevelChange - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */

#include "menulevelchange.h"
#include "GfxManager.h"
#include "soundsamples.h"
#include "eng2d.h"
#include "helpnote.h"
#include "warglobals.h"
#include <string>
using std::string;
using namespace eng2d;

namespace WeWantWar {


const int MenuLevelChange::PLAY_LEVEL;
const int MenuLevelChange::SAVE_GAME;
const int MenuLevelChange::BACK_TO_MAINMENU;


/** Constructor
 */
MenuLevelChange::MenuLevelChange() :
  MenuPage(),
  m_levelnum( 0 )
{
  this->createHelpNotes();
}



/** Destructor
 */
MenuLevelChange::~MenuLevelChange()
{
}


/** Updates the levelchange menu
 */
int MenuLevelChange::update()
{
  // Based on which menuitem has the selection we either fade the help notes
  // in or out.
  int index = 0;
  while ( true ) {
    OverlayItem* pItem = this->getOverlayItem( index );
    if ( pItem == 0 ) {
      break;
    }

    if ( index == this->getSelection() ) {
      pItem->fadeIn( 8 );

    } else {
      pItem->fadeOut( 4 );

    }
    index += 1;
  }


  int ret = MenuPage::NO_PAGE_CHANGE;
  if ( key[MenuPage::s_lastKey] ) {
    return ret;
  }
  
  MenuPage::s_lastKey = KEY_O;
  
  if ( key[KEY_UP] ) {
    MenuPage::s_lastKey = KEY_UP;
    MenuPage::m_selection -= 1;
    if ( MenuPage::m_selection < 0 ) {
      MenuPage::m_selection = 2;
    }
    Sound::playSample(SMP_MENUITEM, false);
    
  } else if ( key[KEY_DOWN] ) {
    MenuPage::s_lastKey = KEY_DOWN;
    MenuPage::m_selection += 1;
    if ( MenuPage::m_selection > 2 ) {
      MenuPage::m_selection = 0;
    }
    Sound::playSample(SMP_MENUITEM, false);
    
  } else if ( key[KEY_ENTER] ) {
    MenuPage::s_lastKey = KEY_ENTER;
    ret = this->checkEnterKey();
    
  } else if ( key[KEY_SPACE] ) {
    MenuPage::s_lastKey = KEY_SPACE;
    ret = this->checkEnterKey();
    
  }
  return ret;
}



/** Redraws this menupage
 */
void MenuLevelChange::redraw()
{
  blit( GfxManager::titlePic, Display::buffer, 0,0, 0,0, 640,480 );
  
  TPrinter out( Display::buffer );
  
  out.font( GfxManager::titleFont, "normal30" );
  out.pos( 150, 220 );
  out.print( "level " );
  out.print( m_levelnum );
  
  // Draw the menuitems
  if ( MenuPage::m_selection == 0 ) {
    out.font( GfxManager::titleFont, "menuitems_sel" );
  } else {
    out.font( GfxManager::titleFont, "menuitems" );
  }
  out.pos( 150,300 );
  out.print( "play level" );
  
  if ( MenuPage::m_selection == 1 ) {
    out.font( GfxManager::titleFont, "menuitems_sel" );
  } else {
    out.font( GfxManager::titleFont, "menuitems" );
  }
  out.pos( 100,330 );
  out.print( "save current game" );
  
  if ( MenuPage::m_selection == 2 ) {
    out.font( GfxManager::titleFont, "menuitems_sel" );
  } else {
    out.font( GfxManager::titleFont, "menuitems" );
  }
  out.pos( 100,360 );
  out.print( "back to main menu" );
  
  // Show the number of lives
  out.align( TPrinter::ALIGN_CENTER );
  out.font( GfxManager::titleFont, "menuitems" );
  out.pos( 530,220 );
  out.print( "lives left" );
  out.pos( 530,240 );
  out.font( GfxManager::titleFont, "menuitems_sel" );
  out.print( WarGlobals::numberOfLives );
}



/** Sets the number of the next level so we can show it to the player
 */
void MenuLevelChange::setLevelNum( int levelnum )
{
  m_levelnum = levelnum;
}


/** Checks the enterkey
 */
int MenuLevelChange::checkEnterKey()
{
  Sound::playSample( SMP_MENUSELECT, false );
  if ( MenuPage::m_selection == PLAY_LEVEL ) {
    return MenuPage::PAGE_CHANGE;
  }
  if ( MenuPage::m_selection == SAVE_GAME ) {
    return MenuPage::PAGE_CHANGE;
  }
  if ( MenuPage::m_selection == BACK_TO_MAINMENU ) {
    return MenuPage::PAGE_CHANGE;
  }
}



/** Creates the help-notes
 */
void MenuLevelChange::createHelpNotes()
{
  std::vector<string>* pTT = new std::vector<string>();
  
  pTT->push_back( "Starts the next level" );
  HelpNote* pItem = new HelpNote( 460, 430, 170, 40, *pTT );
  pItem->setOpacityRange( 0, 180 );
  this->addOverlayItem( pItem );
  delete pTT;
  
  pTT = new std::vector<string>();
  pTT->push_back( "Save this game so you" );
  pTT->push_back( "can continue it later." );
  pItem = new HelpNote( 460, 430, 170, 40, *pTT );
  pItem->setOpacityRange( 0, 180 );
  this->addOverlayItem( pItem );
  delete pTT;
  
  pTT = new std::vector<string>();
  pTT->push_back( "Ends this game and returns" );
  pTT->push_back( "to main menu" );
  pItem = new HelpNote( 460, 430, 170, 40, *pTT );
  pItem->setOpacityRange( 0, 180 );
  this->addOverlayItem( pItem );
  delete pTT;
}


} // end of namespace

